#include <GC.h>

/*
 ***************************************************************************
 *        NAME: Render
 * DESCRIPTION: Render the image
 *   
 *--------------------------------------------------------------------------
 * INPUT:
 *   gc - The graphics context to render into.
 *               
 * OUTPUT:
 *   bool - True if rendered successfully.
 *
 *--------------------------------------------------------------------------
 * NOTES:
 *
 ***************************************************************************
*/
bool Render_lineprim( TGC* gc )
{
  TPixelLine line;

  gc->Versions( 27 );

  if( gc->InitLine( line ) == false ) return false;

  switch( gc->GetVersions() )
  {
    case 0:
      gc->L1t5pb( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 1:
      gc->SquareSignal( line, 250000.0 );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 2:
      gc->L2t5pb( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 3:
      gc->FiveStep( line );
      gc->RenderLine( line, 0, gc->height );
      break;
  
    case 4:
      gc->Bars100( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 5:
      gc->Bars75( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 6:
      gc->BlokDelay( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 7:
      gc->Bowtie1ns( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 8:
      gc->Bowtie2ns( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 9:
      gc->BowtieMarkers( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 10:
      gc->KaderH( line );
      gc->RenderLine( line, 0, gc->height );
      break;
      
    case 11:
      gc->KaderV( line );
      gc->RenderLine( line, 0, gc->height );
      break;
    
    case 12:
      gc->Kader( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 13:
      gc->LSweep( line, 1.0e6, 1.5e7, 1.0 );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 14:
      gc->LSweep( line, 1.0e6, 1.5e7, 0.6 );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 15:
      gc->LSweep( line, 1.0e6, 3.0e7, 1.0 );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 16:
      gc->LSweep( line, 1.0e6, 3.0e7, 0.6 );
      gc->RenderLine( line, 0, gc->height );
      break;
    
    case 17:
      gc->LSweep( line, 1.0e5, 1.1e7, 1.0 );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 18:
      gc->LSweep( line, 1.0e5, 1.1e7, 0.6 );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 19:
      gc->Markers( line, 1.0 );
      gc->RenderLine( line, 0, gc->height );
      break;
     
    case 20:
      gc->Mburst( line, 0.5 );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 21:
      gc->Mburst( line, 0.7 );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 22:
      gc->Notch( line, 3.58e+06 );
      gc->RenderLine( line, 0, gc->height );
      break;
    
    case 23:
      gc->Notch( line, 4.4343e+06 );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 24:
      gc->PulseAndBar1( line );
      gc->RenderLine( line, 0, gc->height );
      break;
  
    case 25:
      gc->PulseAndBar2( line );
      gc->RenderLine( line, 0, gc->height );
      break;

    case 26:
      gc->Ramp( line );
      gc->RenderLine( line, 0, gc->height );
      break;
  }

  return true;
}

